<?php $this->load->view('admin/layout/meta'); ?>
<?php $this->load->view('admin/layout/header'); ?>
<?php $this->load->view('admin/layout/aside'); ?>
<main id="main" class="main">
    <div class="pagetitle">
        <h1>Tamu</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Tamu hari ini</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->
    <section class="section dashboard">
        <div class="row">
            <!-- Left side columns -->
            <div class="col-lg-12">
                <div class="row">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Tamu Hari ini<span></span></h5>
                            <table class="table table-borderless" id="data-table" class="display" style="width:100%">
                                <thead>
                                    <tr>
										<th style="width:5%">No</th>
                                        <th>Nama</th>
                                        <th>Asal Instansi</th>
                                        <th>Bidang</th>
                                        <th>Kategori</th>
                                        <th>Waktu</th>
                                        <th style="text-align:center">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no = 0;
                                    foreach ($tampil->result() as $row) {
                                        $no++;
                                        $nama_suara1 = base_url() . 'images/sound/' . $row->file_name;
                                        $nama_suara2 = base_url() . 'images/sound/' . $row->file_name;
                                        $id = $row->idtamu;
                                    ?>
                                        <tr>
                                            <th><?php echo $no; ?></th>
                                              <td><?php if (strlen($row->nama) > 40) {
                                                        echo $teks = substr($row->nama, 0, 40) . '...';
                                                    } else {
                                                        echo $row->nama;
                                                    } ?></td>
                                            <td><?php if (strlen($row->asalinstansi) > 40) {
                                                        echo $teks = substr($row->asalinstansi, 0, 40) . '...';
                                                    } else {
                                                        echo $row->asalinstansi;
                                                    } ?></td>
                                            <td><?php if (strlen($row->namabidang) > 40) {
                                                        echo $teks = substr($row->namabidang, 0, 40) . '...';
                                                    } else {
                                                        echo $row->namabidang;
                                                    } ?></td>													
                                            <td><?php if (strlen($row->namakategori) > 40) {
                                                        echo $teks = substr($row->namakategori, 0, 40) . '...';
                                                    } else {
                                                        echo $row->namakategori;
                                                    } ?></td>
                                            <td><?php  echo date('H:i', strtotime($row->tanggal)); ?></td>
                                            <td style='text-align:center'>
                                                <a href='#' class='play-button' data-row='<?php echo $id; ?>' data-src1='<?php echo $nama_suara1; ?>' data-src2='<?php echo $nama_suara2; ?>' data-playing='false'>
                                                    <button type='button' class='btn btn-success' name='panggil' title='panggil'><i class='bi bi-megaphone-fill' title='Panggil'></i></button>
                                                </a>
                                                <a href='<?php echo base_url(); ?>admin/tamu/edit/<?php echo $id; ?>'>
                                                    <button type='button' class='btn btn-primary' name='detail' title='detail'><i class='bi bi-pencil' title='Panggil'></i></button>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div><!-- End Recent Sales -->
            <div id="controls">
                <button id="play-button" style="display:none;">Putar</button>
            </div>
        </div>
    </div><!-- End Left side columns -->
    </div>
    </section>
</main><!-- End #main -->

<?php $this->load->view('admin/layout/foot-table'); ?>
<script>
    const audio1 = new Audio();
    const audio2 = new Audio();

    function playSoundByRow(rowId) {
        const soundSrc1 = $(`[data-row='${rowId}']`).data('src1');
        const soundSrc2 = $(`[data-row='${rowId}']`).data('src2');

        audio1.src = soundSrc1;
        audio2.src = soundSrc2;

        audio1.play();
        audio1.addEventListener('ended', () => {
            audio2.play();
            audio2.addEventListener('ended', () => {

            });
        });
    }

    $(document).on('click', '.play-button', function(e) {
        e.preventDefault();
        const rowId = $(this).data('row');
        const isPlaying = $(this).data('playing') === true;

 if (!isPlaying) {
        playSoundByRow(rowId);
        $(this).data('playing', true);
        $(this).find("button").removeClass("btn-success").addClass("btn-danger");
        $(this).find("i").removeClass("bi-megaphone-fill").addClass("bi-stop-circle");
    } else {
        audio1.pause();
        audio2.pause(); 
        $(this).data('playing', false);
        $(this).find("button").removeClass("btn-danger").addClass("btn-success");
        $(this).find("i").removeClass("bi-stop-circle").addClass("bi-megaphone-fill");
    }
    });

    function fetchData() {
        $.ajax({
            url: '<?php echo base_url().'admin/tamu/getNewData';?>',
            method: 'GET',
            dataType: 'json',
            success: function(response) {
                $('#data-table tbody').empty();

				$.each(response, function(index, item) {
						// Mengonversi tanggal menjadi objek Date
						var tanggalObj = new Date(item.tanggal);

						// Mendapatkan jam dan menit dalam format "HH:ii"
						var jamMenit = ('0' + tanggalObj.getHours()).slice(-2) + ':' + ('0' + tanggalObj.getMinutes()).slice(-2);
					var row = '<tr>' +
						'<td>' + (index + 1) + '</td>' + // Nomor urut
                        '<td>' + (item.nama.length > 20 ? item.nama.substr(0, 20) + '...' : item.nama) + '</td>' +
                        '<td>' + (item.asalinstansi.length > 20 ? item.asalinstansi.substr(0, 20) + '...' : item.asalinstansi) + '</td>' +
                        '<td>' + (item.namakategori.length > 20 ? item.namakategori.substr(0, 20) + '...' : item.namakategori) + '</td>' +
                        '<td>' + jamMenit+ '</td>' +
                        '<td style="text-align:center">' +
                            '<a href="#" class="play-button" data-row="' + item.idtamu + '" data-src1="<?php echo base_url();?>images/sound/' + item.file_name + '" data-src2="<?php echo base_url();?>images/sound/' + item.file_name + '" data-playing="false">' +
                                '<button type="button" class="btn btn-success" name="panggil" title="panggil"><i class="bi bi-megaphone-fill" title="Panggil"></i></button>' +
                            '</a>' +
                            '<a href="<?php echo base_url(); ?>admin/tamu/edit/' + item.idtamu + '">' +
                                '<button type="button" class="btn btn-primary" name="detail" title="detail"><i class="bi bi-pencil" title="Panggil"></i></button>' +
                            '</a>' +
                        '</td>' +
                        '</tr>';
                    $('#data-table tbody').append(row);
                });
            },
            error: function(xhr, status, error) {
                console.error(error);
            }
        });
    }

    setInterval(fetchData, 15000);
</script>
<?php $this->load->view('admin/layout/foot'); ?>
